/*
 * Written by Dawid Kurzyniec and released to the public domain, as explained
 * at http://creativecommons.org/licenses/publicdomain
 */

package edu.emory.mathcs.util.remote.server;

import java.io.*;
import java.rmi.*;

/**
 * Server interface to the remote native process.
 *
 * @see edu.emory.mathcs.util.remote.RemoteProcess
 *
 * @author Dawid Kurzyniec
 * @version 1.0
 */
public interface RemoteProcessSrv extends Remote {

    void destroy() throws RemoteException;
    int waitFor() throws RemoteException, InterruptedException;
    int exitValue() throws RemoteException;

    byte[] readFromIn(int maxbytes) throws IOException;
    int availableInIn() throws IOException;
    long skipInIn(long n) throws IOException;
    void closeIn() throws IOException;

    byte[] readFromErr(int maxbytes) throws IOException;
    int availableInErr() throws IOException;
    long skipInErr(long n) throws IOException;
    void closeErr() throws IOException;

    void writeToOut(byte[] buf) throws IOException;
    void flushOut() throws IOException;
    void closeOut() throws IOException;
}
